﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;

namespace VistATool.Controllers
{
    public class HospitalLocationController : Controller
    {
        //
        // GET: /HospitalLocation/

        public ActionResult Index()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                List<HOSPITAL_LOCATION> list = db.HOSPITAL_LOCATION.ToList();
                return View(list);
            }
        }

        public ActionResult Create()
        {            
            return View();
        }

        [HttpPost]
        public ActionResult Create(HOSPITAL_LOCATION hospLocation)
        {
            try
            {                
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.HOSPITAL_LOCATION.Add(hospLocation);
                    db.SaveChanges();
                }
                return RedirectToAction("Index");                
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
            }                        
            return View();
        }

        // GET: /HospitalLocation/Edit/id
        public ActionResult Edit(int id)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {             
                return View(db.HOSPITAL_LOCATION.Find(id));
            }
        }

        [HttpPost]
        public ActionResult Edit(int id, HOSPITAL_LOCATION hospital)
        {
            try
            {                
                using (var db = new BMS_VISTA_DBEntities())
                {
                    db.Entry(hospital).State = System.Data.EntityState.Modified;
                    db.SaveChanges();
                    return RedirectToAction("Index");
                }                
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
            }
            return View();
        }

        #region Private Methods

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        #endregion


    }
}
